/**
  ******************************************************************************
  * @file    LowPower.h
  * @author  Milandr Application Team
  * @version V1.2.0
  * @date    10.12.2013
  * @brief   This file contains all the function prototypes for work with Low Power
  ******************************************************************************
  * <br><br>
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, Milandr SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2013 Milandr</center></h2>
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __LOWPOWER_H
#define __LOWPOWER_H

/* Includes ------------------------------------------------------------------*/
#include <MDR32F9Qx_config.h>
#include "types.h"

/** @addtogroup __MDR1986VE3_Eval_Demo MDR1986VE3 Demonstration Example
  * @{
  */

/** @addtogroup Menu Menu
  * @{
  */

/** @addtogroup Menu_LowPower Menu Low Power
  * @{
  */

/** @defgroup Menu_LowPower_Exported_Constants Menu Low Power Exported Constants
  * @{
  */

/** @} */ /* End of group Menu_LowPower_Exported_Constants */

/** @defgroup Menu_LowPower_Exported_Macros Menu Low Power Exported Macros
  * @{
  */

/** @} */ /* End of group Menu_LowPower_Exported_Macros */

/** @defgroup Menu_LowPower_Exported_Variables Menu Low Power Exported Variables
  * @{
  */

/** @} */ /* End of group Menu_LowPower_Exported_Variables */

/** @defgroup Menu_LowPower_Exported_Functions Menu Low Power Exported Functions
  * @{
  */

void LowPower_Init(void);

/** @} */ /* End of group Menu_LowPower_Exported_Functions */

/** @} */ /* End of group Menu_LowPower */

/** @} */ /* End of group Menu */

/** @} */ /* End of group __MDR1986VE3_Eval_Demo */

#endif /* __LOWPOWER_H */

/******************* (C) COPYRIGHT 2013 Milandr *********************************
*
* END OF FILE LowPower.h */


